/*
 * Decompiled with CFR 0.152.
 */
import edu.fauser.netlab.UniqueRandom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;

public class ClientLotto {
    static final String SERVER = "localhost";
    static final int PORTA_SERVER = 5060;
    static final int MAX_NUMERI_LOTTO = 10;

    public static void main(String[] args) {
        ArrayList<Integer> numeri = ClientLotto.generaNumeri();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numeri.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(numeri.get(i));
        }
        String strNumeri = sb.toString();
        System.out.format("Generati i numeri: %s%n", strNumeri);
        System.out.println("Connessione alla ricevitoria in corso...");
        try (Socket sck = new Socket(SERVER, 5060);){
            String loc = sck.getLocalSocketAddress().toString();
            String rem = sck.getRemoteSocketAddress().toString();
            System.out.format("Client: %s%n", loc);
            System.out.format("Server: %s%n", rem);
            ClientLotto.trasmettiRicevi(sck, strNumeri);
            System.out.println("Programma client terminato");
        }
        catch (UnknownHostException e) {
            System.err.format("Nome di server non valido: %s%n", e.getMessage());
        }
        catch (IOException e) {
            System.err.format("Errore durante la comunicazione con la ricevitoria: %s%n", e.getMessage());
        }
    }

    private static void trasmettiRicevi(Socket sck, String strNumeri) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF-8"));
             PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(sck.getOutputStream(), "UTF-8"), true);){
            System.out.println("Invio dei numeri in corso...");
            out.println(strNumeri);
            System.out.println("In attesa di ricevere l'esito dell'estrazione");
            String buffer1 = in.readLine();
            if (buffer1 == null) {
                return;
            }
            System.out.println(buffer1);
            String buffer2 = in.readLine();
            if (buffer2 == null) {
                return;
            }
            System.out.println(buffer2);
        }
    }

    private static ArrayList<Integer> generaNumeri() {
        ArrayList<Integer> ris = new ArrayList<Integer>();
        UniqueRandom ur = new UniqueRandom(1L, 11L);
        for (int i = 0; i < 3; ++i) {
            int n = ur.nextInt();
            ris.add(n);
        }
        Collections.sort(ris);
        return ris;
    }
}

