/*
 * Decompiled with CFR 0.152.
 */
package edu.fauser.netlab;

import java.math.BigInteger;
import java.util.StringJoiner;

public final class UniqueRandom {
    public static final long maxLimit = 0x7FFFFFFFFFFFFFE7L;
    private long lowerLimit;
    private long upperLimit;
    private long limit;
    private long seed;
    private long prime;
    private long a;
    private long b;
    private long c;
    private long state;
    private int maxIterations;

    public UniqueRandom(long lowerLimit, long upperLimit) {
        this(lowerLimit, upperLimit, System.currentTimeMillis());
    }

    public UniqueRandom(long lowerLimit, long upperLimit, long seed) {
        this.setLimitsAndSeed(lowerLimit, upperLimit, seed);
    }

    public void setLimitsAndSeed(long lowerLimit, long upperLimit, long seed) {
        if (lowerLimit >= upperLimit) {
            throw new IllegalArgumentException("Lower limit must be less than upper limit");
        }
        long range = upperLimit - lowerLimit;
        if (range < 0L || range > 0x7FFFFFFFFFFFFFE7L) {
            throw new IllegalArgumentException("The range supplied is too large");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.limit = range;
        this.seed = seed;
        this.state = 0L;
        this.maxIterations = 3;
        this.prime = range;
        while (!this.isPrime(this.prime)) {
            ++this.prime;
        }
        long alpha1 = (seed ^ 0x34E95D3E7A29F36CL) & 0x3FFFFFFFFFFFFFFFL;
        long alpha2 = (Long.rotateLeft(seed, 4) ^ 0x278C1AD459AB4A7EL) & 0x3FFFFFFFFFFFFFFFL;
        long beta1 = (seed ^ 0x2A09273B259AE38BL) & 0x3FFFFFFFFFFFFFFFL;
        long beta2 = (Long.rotateRight(seed, 2) ^ 0x5B8619AA265D9D3AL) & 0x3FFFFFFFFFFFFFFFL;
        this.a = this.prime / 2L + (alpha1 + alpha2) % (this.prime / 2L);
        this.b = (beta1 + beta2) % this.prime;
        this.c = 3L;
        while (this.c < this.prime && this.gcd(this.c, this.prime - 1L) != 1L) {
            ++this.c;
        }
        if (this.c >= this.prime) {
            this.c = 1L;
        }
    }

    public synchronized int nextInt() {
        long result;
        if (this.lowerLimit < Integer.MIN_VALUE || this.upperLimit > 0x80000000L) {
            throw new IllegalStateException("The result does not fit into the 32-bit signed integer.");
        }
        while ((result = this.compute32(this.state++)) >= this.limit) {
        }
        return (int)(this.lowerLimit + result);
    }

    public synchronized long nextLong() {
        long result;
        while ((result = this.lowerLimit >= Integer.MIN_VALUE && this.upperLimit <= Integer.MAX_VALUE ? this.compute32(this.state++) : this.compute64(this.state++)) >= this.limit) {
        }
        return this.lowerLimit + result;
    }

    public String getStateInfo() {
        StringJoiner sj = new StringJoiner("; ", "{", "}");
        sj.add(String.format("Lower limit: %d", this.lowerLimit));
        sj.add(String.format("Upper limit: %d", this.upperLimit));
        sj.add(String.format("Limit: %d", this.limit));
        sj.add(String.format("Seed: %d", this.seed));
        sj.add(String.format("Prime: %d", this.prime));
        sj.add(String.format("A: %d", this.a));
        sj.add(String.format("B: %d", this.b));
        sj.add(String.format("C: %d", this.c));
        sj.add(String.format("State: %d", this.state));
        return sj.toString();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    private long compute64(long st) {
        int n = this.maxIterations;
        if (this.c == 0L) {
            return 1L;
        }
        long xs = st;
        for (int i = 0; i < n; ++i) {
            long temp1 = this.mul64(this.a, xs, this.prime);
            long temp2 = this.add64(temp1, this.b, this.prime);
            xs = this.pow64(temp2, this.c, this.prime);
        }
        return xs;
    }

    private long compute32(long st) {
        int n = this.maxIterations;
        if (this.c == 0L) {
            return 1L;
        }
        long x = st;
        for (int i = 0; i < n; ++i) {
            long temp = (this.a * x + this.b) % this.prime;
            x = this.pow32(temp, this.c, this.prime);
        }
        return x;
    }

    private long pow32(long x, long exp, long m) {
        long res = 1L;
        while (exp > 0L) {
            if ((exp & 1L) != 0L) {
                res = res * x % m;
            }
            exp >>= 1;
            x = x * x % m;
        }
        return res;
    }

    private long pow64(long base, long exp, long m) {
        long res = 1L;
        while (exp > 0L) {
            if ((exp & 1L) != 0L) {
                res = this.mul64(res, base, m);
            }
            exp >>= 1;
            base = this.mul64(base, base, m);
        }
        return res;
    }

    private long mul64(long x, long y, long m) {
        int shift = 32;
        long mask = 0xFFFFFFFFL;
        long xhi = x >> 32;
        long yhi = y >> 32;
        long xlo = x & 0xFFFFFFFFL;
        long ylo = y & 0xFFFFFFFFL;
        long res = xlo * ylo;
        long reslo = res & 0xFFFFFFFFL;
        res >>>= 32;
        res >>>= 32;
        long reshi = res += xhi * yhi;
        long temp = 0L;
        if ((reslo |= (res += xhi * ylo + xlo * yhi) << 32) < 0L) {
            reslo &= Long.MAX_VALUE;
            temp = 1L + Long.MAX_VALUE % m;
        }
        if (reshi == 0L) {
            res = this.add64(temp, reslo, m);
        } else {
            long temp2 = 2L + this.add64(Long.MAX_VALUE, Long.MAX_VALUE, m);
            long temp3 = this.mul64(reshi, temp2, m);
            long temp4 = this.add64(temp, temp3, m);
            res = this.add64(temp4, reslo, m);
        }
        return res;
    }

    private long add64(long x, long y, long m) {
        long res = x + y;
        while (res < 0L) {
            long temp = 1L + Long.MAX_VALUE % m;
            res = (res & Long.MAX_VALUE) + temp;
        }
        return res % m;
    }

    private long gcd(long a, long b) {
        while (b != 0L) {
            long t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private boolean isPrime(long n) {
        BigInteger bi = BigInteger.valueOf(n);
        return bi.isProbablePrime(100);
    }
}

