/*
 * Decompiled with CFR 0.152.
 */
import edu.fauser.netlab.UniqueRandom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ServerLotto {
    static final int PORTA_SERVER = 5060;
    static final int MAX_GIOCATORI = 2;
    static final int MAX_NUMERI_LOTTO = 10;
    static ServerSocket globalServerSck;
    static ExecutorService pool;
    static ArrayList<Integer> numeriVincenti;
    static CountDownLatch giocatoriAttesi;
    static CountDownLatch estrazioniAttese;

    public static void main(String[] args) {
        try (ServerSocket server = new ServerSocket(5060);){
            globalServerSck = server;
            pool.execute(() -> ServerLotto.eseguiEstrazione());
            System.out.format("Ricevitoria lotto in ascolto su: %s%n", server.getLocalSocketAddress());
            while (!server.isClosed()) {
                try {
                    Socket tempSck = server.accept();
                    pool.execute(() -> ServerLotto.gestisciClient(tempSck));
                }
                catch (IOException e) {
                    if (server.isClosed()) continue;
                    System.err.println(String.format("Errore nella gestione di nuove connessioni:%s", e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            System.err.println(String.format("Errore del server: %s", e.getMessage()));
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            System.out.println("Programma ricevitoria terminato");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void eseguiEstrazione() {
        try {
            giocatoriAttesi.await();
            globalServerSck.close();
            System.out.format("%nRicevitoria chiusa, non si accettano pi\u00f9 giocatori...%n", new Object[0]);
            System.out.println("Estrazione dei cinque numeri vincenti");
            UniqueRandom ur = new UniqueRandom(1L, 11L, 2023L);
            numeriVincenti.clear();
            for (int i = 0; i < 5; ++i) {
                numeriVincenti.add(ur.nextInt());
            }
            Collections.sort(numeriVincenti);
            System.out.print("I numeri estratti sono:");
            for (Integer v : numeriVincenti) {
                System.out.format(" %d", v);
            }
            System.out.println();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        estrazioniAttese.countDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void gestisciClient(Socket sck) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF-8"));
             PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(sck.getOutputStream(), "UTF-8"), true);){
            ArrayList<Integer> listaNumeri = new ArrayList<Integer>();
            String str = br.readLine();
            if (str == null) {
                sck.close();
                return;
            }
            System.out.format("Ricevuto da %s i seguenti numeri: %s%n", sck.getRemoteSocketAddress(), str);
            String[] parti = str.split(" ");
            if (parti.length != 3) {
                String errore = "\u00c8 richiesto l'invio di tre numeri";
                System.err.println(errore);
                pw.println(errore);
                sck.close();
                return;
            }
            for (String p : parti) {
                try {
                    int i = Integer.parseInt(p);
                    listaNumeri.add(i);
                }
                catch (NumberFormatException e) {
                    String errore = String.format("Numero non valido: %s", p);
                    System.err.println(errore);
                    pw.println(errore);
                    sck.close();
                    pw.close();
                    br.close();
                    return;
                }
            }
            giocatoriAttesi.countDown();
            estrazioniAttese.await();
            StringBuilder sb = new StringBuilder();
            for (Integer v : numeriVincenti) {
                sb.append(String.format("%d ", v));
            }
            String[] esiti = new String[]{"NESSUN NUMERO ESTRATTO", "UN NUMERO ESTRATTO", "AMBO", "TERNO"};
            int estratti = ServerLotto.contaNumeriEstratti(listaNumeri, numeriVincenti);
            sb.append(esiti[estratti]);
            pw.println(sb);
            sck.close();
            return;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(String.format("Codifica di caratteri non supportata: %s", e.getMessage()));
            return;
        }
        catch (IOException e) {
            System.err.println(String.format("Errore di I/O: %s", e.getMessage()));
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static int contaNumeriEstratti(ArrayList<Integer> listaNumeri, ArrayList<Integer> numeriVincenti) {
        int conta = 0;
        for (Integer n : listaNumeri) {
            if (numeriVincenti.indexOf(n) < 0) continue;
            ++conta;
        }
        return conta;
    }

    static {
        pool = Executors.newCachedThreadPool();
        numeriVincenti = new ArrayList();
        giocatoriAttesi = new CountDownLatch(2);
        estrazioniAttese = new CountDownLatch(1);
    }
}

