/*
 *            File: ClientLotto.java
 *          Autore: Roberto FULIGNI
 * Ultima modifica: 20/11/2023
 *
 *     Descrizione: Problema n. 5 pag. 135 del libro di testo
 *                  (sistema di estrazioni del lotto - modulo client)
 */

import edu.fauser.netlab.UniqueRandom;

import java.io.*;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;

public class ClientLotto {
    final static String SERVER = "localhost";
    final static int PORTA_SERVER = 5060;
    final static int MAX_NUMERI_LOTTO = 10;

    public static void main(String[] args) {
        var numeri = generaNumeri();
        var sb = new StringBuilder();
        for(int i = 0; i < numeri.size(); i++) {
            if (i > 0)
                sb.append(" ");
            sb.append(numeri.get(i));
        }

        var strNumeri = sb.toString();
        System.out.format("Generati i numeri: %s%n", strNumeri);

        System.out.println("Connessione alla ricevitoria in corso...");
        try (var sck = new Socket(SERVER, PORTA_SERVER)) {

            String loc = sck.getLocalSocketAddress().toString();
            String rem = sck.getRemoteSocketAddress().toString();
            System.out.format("Client: %s%n", loc);
            System.out.format("Server: %s%n", rem);

            trasmettiRicevi(sck, strNumeri);

            System.out.println("Programma client terminato");

        } catch (UnknownHostException e) {
            System.err.format("Nome di server non valido: %s%n", e.getMessage());
        } catch (IOException e) {
            System.err.format("Errore durante la comunicazione con la ricevitoria: %s%n",
                    e.getMessage());
        }
    }

    private static void trasmettiRicevi(Socket sck, String strNumeri) throws IOException{
        try (
                var in = new BufferedReader(
                        new InputStreamReader(sck.getInputStream(), "UTF-8"));
                var out = new PrintWriter(
                        new OutputStreamWriter(sck.getOutputStream(), "UTF-8"), true);
        ) {
            System.out.println("Invio dei numeri in corso...");
            out.println(strNumeri);
            System.out.println("In attesa di ricevere l'esito dell'estrazione");

            var buffer1 = in.readLine();
            if (buffer1 == null) {
                return;
            }
            System.out.println(buffer1);

            var buffer2 = in.readLine();
            if (buffer2 == null) {
                return;
            }

            System.out.println(buffer2);
        }
    }

    private static ArrayList<Integer> generaNumeri() {
        var ris = new ArrayList<Integer>();
        var ur = new UniqueRandom(1, MAX_NUMERI_LOTTO+1);
        for (int i = 0; i < 3; i++) {
            var n = ur.nextInt();
            ris.add(n);
        }
        Collections.sort(ris);

        return ris;
    }
}