﻿/*
 *         Progetto: Calcolo del percorso a costo minimo mediante algoritmo di Dijkstra 
 * 
 *           Autore: Roberto Fuligni
 *  Ultima modifica: 07/03/2022
 *  
 *      Descrizione: Costruisce un grafo pesato e determina il MST a partire da un dato nodo sorgente.
 *                   Il grafo iniziale e il MSt sono visualizzati in formato GraphViz.
 */

using LibreriaGrafi;
using System;

namespace PercorsoDijkstra
{
    class PercorsoDijkstra
    {
        static void Main(string[] args)
        {
            // Esempio di grafo non orientato con sei nodi.
            // Gli archi non hanno pesi negativi

            const int NumeroNodi = 6;
            var g = new Grafo(NumeroNodi, Grafo.Tipo.NonOrientato);
            g[0, 1] = 4; g[0, 5] = 3; g[0, 1] = 4;
            g[0, 5] = 3; g[1, 2] = 2; g[1, 4] = 5;
            g[1, 5] = 1; g[2, 3] = 2; g[3, 4] = 1;
            g[3, 5] = 6; g[4, 5] = 20;

            Console.WriteLine("Per visualizzare un grafo: https://dreampuf.github.io/GraphvizOnline");
            Console.WriteLine("# GRAFO INIZIALE");
            Console.WriteLine(g);
            
            Grafo mst = g.Dijkstra(0);
            
            Console.WriteLine();
            Console.WriteLine("# MST");
            Console.WriteLine(mst);
        }
    }
}
